// AddMasterHoliday.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "AddMasterHoliday.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CAddMasterHoliday dialog


CAddMasterHoliday::CAddMasterHoliday(CWnd* pParent /*=NULL*/)
	: CDialog(CAddMasterHoliday::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAddMasterHoliday)
	m_sMasterHolidayName = _T("");
	m_bEveryYear = FALSE;
	m_bMaster = TRUE;
	m_sHGName = _T("");
	m_lDay = 0;
	m_lMonth = 0;
	m_lYear = 0;
	//}}AFX_DATA_INIT
}

CAddMasterHoliday ::CAddMasterHoliday(IApplication *pApp, BOOL bMaster /* = FALSE */)
:CDialog(CAddMasterHoliday::IDD, NULL)
{
	pApplication = pApp;
	m_bMaster = bMaster;
	m_sHGName = _T("");

	m_lDay = 0;
	m_lYear = 0;
	m_lMonth = 0;

	pMasterHol.CreateInstance(__uuidof(MasterHoliday));
	
}

void CAddMasterHoliday::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAddMasterHoliday)
	DDX_Control(pDX, IDC_CMB_HGID, m_HGList);
	DDX_Control(pDX, IDC_CMB_ACCT, m_AcctList);
	DDX_Control(pDX, IDC_RADIO_HOLIDAY1, m_Holiday1);
	DDX_Control(pDX, IDC_RADIO_HOLIDAY2, m_Holiday2);
	DDX_Text(pDX, IDC_NAME_MASTERHOLIDAY, m_sMasterHolidayName);
	DDX_Check(pDX, IDC_CHECK_EVERYYEAR, m_bEveryYear);
	DDX_Control(pDX, IDC_RADIO_HOLIDAY3, m_Holiday3);
	DDX_Text(pDX, IDC_TXT_HGNAME, m_sHGName);
	DDX_Text(pDX, IDC_EDIT_DAY, m_lDay);
	DDX_Text(pDX, IDC_EDIT_MONTH, m_lMonth);
	DDX_Text(pDX, IDC_EDIT_YEAR, m_lYear);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAddMasterHoliday, CDialog)
	//{{AFX_MSG_MAP(CAddMasterHoliday)
	ON_BN_CLICKED(IDC_BUTTON_ADD, OnButtonAdd)
	ON_CBN_SELCHANGE(IDC_CMB_ACCT, OnSelchangeAcct)
	ON_CBN_SELCHANGE(IDC_CMB_HGID, OnSelchangeHGList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAddMasterHoliday message handlers

void CAddMasterHoliday::OnButtonAdd() 
{
		BSTR bstrMasterHolName;
		UpdateData(TRUE);
		//select account name 
		long lEveryYear = 0;
		long lHolidayType = 0;
		if(m_Holiday1.GetCheck() == 1)
			lHolidayType = 1;
		if(m_Holiday2.GetCheck() == 1)
			lHolidayType = 2;
		// For Holiday Type 3 Changes -- Guru
		if(m_Holiday3.GetCheck() == 1)
			lHolidayType = 3;

		if(m_bEveryYear == 1)
			lEveryYear = 1;
		//bstrHolidayDate = m_sDate.AllocSysString();
		//get the access level name and description
		bstrMasterHolName = m_sMasterHolidayName.AllocSysString();
		
	//set time zone properties
		pMasterHol->ApplyAllYears = lEveryYear;
		pMasterHol->HolidayType = lHolidayType;
		pMasterHol->Name	= bstrMasterHolName;

		int index = m_AcctList.GetCurSel();
		if(index<0)
		{
			AfxMessageBox(_T("Account not selected"));
			return;
		}

		CString sAcctID;
		m_AcctList.GetLBText(index,sAcctID);
		long lAcctID = _wtoi(sAcctID);
		pMasterHol->AccountID = lAcctID;
		
		
		//get the Account Name by AccountID
		BSTR bstrAcctName; 
		pApplication->GetAccountNameByAcctID(lAcctID,&bstrAcctName);
		pMasterHol->AccountName = bstrAcctName;
		 

		//pMasterHol->Holiday = bstrHolidayDate;
		try
		{
			pMasterHol->Day = m_lDay;
			pMasterHol->Month = m_lMonth;
			pMasterHol->Year = m_lYear;
		}
		catch(CString errStr)
		{
			AfxMessageBox(errStr);
			return;
		}
		catch(...)
		{
			return;
		}

		long lStatus, lHolID;
		if(m_bMaster)
		{
			// Do Nothing
		}
		else
		{
			int index_HG = m_HGList.GetCurSel();
			if(index_HG<0)
				return ;
			CString sHGID;
			m_HGList.GetLBText(index_HG, sHGID);
			long lHGID = _wtoi(sHGID);

			pMasterHol->HolidayGroupID = lHGID;
			pApplication->AddHoliday(pMasterHol, &lHolID, &lStatus);
		}
		::SysFreeString(bstrMasterHolName);
		
		
		if(lStatus == 700)
		{
			AfxMessageBox(L"InValid Holiday name");
			return;
		}
		if (lStatus == 701)
		{
			AfxMessageBox(L"Invalid Holiday Name string length");
			return;
		}
		if ( lStatus == 702)
		{
			AfxMessageBox(L"Holiday Name Exists");
			return ;
		}
		if (lStatus == 703)
		{
			AfxMessageBox(L"Invalid Holiday type");
			return ;
		}
		if (lStatus == 704)
		{
			AfxMessageBox(L"Invalid definition for every year");
			return ;
		}
		if (lStatus == 705)
		{
			AfxMessageBox(L"Invalid holiday date");
			return ;
		}
		if (lStatus == 807)
		{
			AfxMessageBox(L"Holiday Name Exists in Holiday Group");
			return ;
		}
		if (lStatus == 808)
		{
			AfxMessageBox(L"Holiday date Exists in Holiday Group");
			return ;
		}	
		if(lStatus == 0)
		{
			AfxMessageBox(L"Holiday Addition succeeded");
			CDialog::OnOK();
		}
		else
		{
			AfxMessageBox(L"Holiday Addition Failed");
			return ;
		}
		UpdateData(FALSE);
}	

BOOL CAddMasterHoliday::OnInitDialog() 
{
	CDialog::OnInitDialog();
	GetDlgItem(IDC_CMB_ACCT)->EnableWindow(!m_bMaster);
	GetDlgItem(IDC_CMB_HGID)->EnableWindow(!m_bMaster);

	if(!m_bMaster)
	{
		LoadAccounts();
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CAddMasterHoliday::LoadAccounts()
{
	_variant_t vAccounts;
	vAccounts.Clear();
	pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
	
	if(vAccounts.vt ==  VT_EMPTY)
	{
		return;
	}
	
	long uBound =0 ;
	IAccount *pAccount = NULL;
	
	COleSafeArray sa(vAccounts);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	for(long i =0 ;i <= uBound ; i++)
		
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
		if (pAccount != NULL)
		{
			CString sAcctID;
			sAcctID.Format(L"%ld",pAccount->AccountID); 
			m_AcctList.AddString(sAcctID);
			pAccount->Release();
		}
		pDisp->Release();
	}
	UpdateData(FALSE);
}

void CAddMasterHoliday::LoadHolidayGroups()
{
	int index = m_AcctList.GetCurSel();
	if(index<0)
		return;
	CString sAcctID;
	m_AcctList.GetLBText(index,sAcctID);
	long lAcctID = _wtoi(sAcctID);

	_variant_t vHolidayGrps;
	vHolidayGrps.Clear();
	pApplication->GetHolidayGroupsByAcctID(lAcctID, &vHolidayGrps);
	
	if(vHolidayGrps.vt ==  VT_EMPTY)
	{
		return;
	}
	
	long uBound =0 ;
	IHolidayGroup *pHG = NULL;
	
	COleSafeArray sa(vHolidayGrps);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	for(long i =0 ;i <= uBound ; i++)	
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IHolidayGroup,(void**)&pHG);
		if (pHG != NULL)
		{
			CString sHGID;
			sHGID.Format(L"%ld",pHG->HolGrpID);
			m_HGList.AddString(sHGID);
			pHG->Release();
		}
		pDisp->Release();
	}
	UpdateData(FALSE);
		
}

void CAddMasterHoliday::OnSelchangeAcct() 
{
	m_HGList.ResetContent();
	LoadHolidayGroups();
}

void CAddMasterHoliday::OnSelchangeHGList() 
{
	int index = m_AcctList.GetCurSel();
	if(index<0)
		return;
	CString sAcctID;
	m_AcctList.GetLBText(index,sAcctID);
	long lAcctID = _wtoi(sAcctID);

	int index_HG = m_HGList.GetCurSel();
	if(index_HG<0)
		return;
	CString sHGID;
	m_HGList.GetLBText(index_HG, sHGID);
	long lHGID = _wtoi(sHGID);

		_variant_t vHolidayGrps;
	vHolidayGrps.Clear();
	pApplication->GetHolidayGroupsByAcctID(lAcctID, &vHolidayGrps);
	
	if(vHolidayGrps.vt ==  VT_EMPTY)
	{
		return;
	}
	
	long uBound =0 ;
	IHolidayGroup *pHG = NULL;
	
	COleSafeArray sa(vHolidayGrps);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	for(long i =0 ;i <= uBound ; i++)	
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IHolidayGroup,(void**)&pHG);
		if (pHG != NULL)
		{
			if(lHGID == pHG->HolGrpID)
			{
				m_sHGName = (LPCSTR) pHG->HolGrpName;
				break;
			}
		}
		pDisp->Release();
	}
	UpdateData(FALSE);

}
